package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.DictEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-24
 * 推啊业务-维度对应的属性字段
 */
public enum TuiaDictEnum implements DictEnum {

    //媒体名称
    APP_NAME(TuiaDimensionEnum.APP_ID.toString(), "app_name", "媒体名称")


    ;


    //关联的维度字段
    private final String dimensionName;

    //mysql表中对应的字段名称
    private final String tableFieldName;

    //属性字段说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaDictEnum(String dimensionName, String tableFieldName, String desc) {
        this.dimensionName = dimensionName;
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDimensionName() {
        return dimensionName;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaDictEnum[] values = TuiaDictEnum.values();
        for (TuiaDictEnum value : values) {
            enumList.add(value.toString());
        }
    }

}
