package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.DimensionEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-24
 * 推啊业务-维度字段
 */
public enum TuiaDimensionEnum implements DimensionEnum {

    //媒体id
    APP_ID("app_id", "appId", "int", "媒体id"),

    //广告位id
    SLOT_ID("slot_id", "slotId", "int", "广告位id"),

    //活动id
    ACTIVITY_ID("activity_id", "activityId", "int", "活动id"),

    //广告id
    ADVERT_ID("advert_id", "advertId", "int", "广告id"),

    //实验计划id
    ABTEST_PLAN_ID("abtest_plan_id", "abtestPlanId", "int", "实验计划id"),

    //实验分组id
    ABTEST_GROUP_ID("abtest_group_id", "abtestGroupId", "int", "实验分组id"),

    //实验计划和分组
    ABTEST("ab_test", "abtest", "array-string", "字符串数组，每个元素的格式：实验计划id-实验分组id"),


    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //结果数据对应的别名
    private final String resultFieldName;

    //hologres 表中的字段类型(String, int, bigint等等)
    private final String fieldType;

    //维度字段解释说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaDimensionEnum(String tableFieldName, String resultFieldName, String fieldType, String desc) {
        this.tableFieldName = tableFieldName;
        this.resultFieldName = resultFieldName;
        this.fieldType = fieldType;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getFieldType() {
        return fieldType;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaDimensionEnum[] values = TuiaDimensionEnum.values();
        for (TuiaDimensionEnum value : values) {
            enumList.add(value.toString());
        }
    }
}
