package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.MetricEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-24
 * 推啊业务-基础指标字段
 */
public enum TuiaMetricEnum implements MetricEnum {

    //广告位访问pv
    SLOT_VISIT_PV("slotVisitPV", "count(1)", "duiba_access_log_detail_month", "url_host = 'activity.tuia.cn' and tenter='SOW'", "广告位访问pv"),

    //广告位访问uv
    SLOT_VISIT_UV("slotVisitUV", "approx_count_distinct(consumer_id)", "duiba_access_log_detail_month", "url_host = 'activity.tuia.cn' and tenter='SOW'", "广告位访问uv"),

    //活动请求pv

    //活动请求uv

    //活动参与pv

    //活动参与uv

    //券请求pv
    COUPON_REQUEST_PV("couponRequestPV", "count(1)", "duiba_inner_log_detail_month", "inner_group = 1 and inner_type = 23", "券请求pv"),

    //券请求uv
    COUPON_REQUEST_UV("couponRequestUV", "approx_count_distinct(consumer_id)", "duiba_inner_log_detail_month", "inner_group = 1 and inner_type = 23", "券请求uv"),

    //发券量pv
    LAUNCH_COUPON_PV("launchCouponPV", "count(1)", "tuia_all_log_detail_month", "inner_group = 1 and inner_type = 20", "发券量pv"),

    //券曝光pv
    COUPON_EXPOSURE_PV("couponExposurePV", "count(1)", "duiba_inner_log_detail_month", "inner_group = 1 and inner_type = 22", "券曝光pv"),

    //券普通点击pv
    COUPON_CLICK_PV("couponClickPV", "count(1)", "duiba_inner_log_detail_month", "inner_group = 1 and inner_type = 21", "券普通点击pv"),

    //券普通点击uv
    COUPON_CLICK_UV("couponClickUV", "approx_count_distinct(consumer_id)", "duiba_inner_log_detail_month", "inner_group = 1 and inner_type = 21", "券普通点击uv"),

    //券计费点击pv
    COUPON_EFFECT_CLICK_PV("couponEffectClickPV", "count(1)", "tuia_all_log_detail_month", "inner_group = 1 and inner_type = 25", "券计费点击pv"),

    //消耗
    CONSUME("consume", "sum(fee)", "tuia_all_log_detail_month", "inner_group = 1 and inner_type = 25", "消耗"),

    //平台消耗(利润扣量后的消耗)
    PLATFORM_CONSUME("platformConsume", "sum(platform_fee)", "duiba_inner_log_detail_month", "inner_group = 1 and inner_type = 25", "平台消耗(利润扣量后的消耗)"),





    ;


    //结果数据对应的别名
    private final String resultFieldName;

    //指标sql代码段
    private final String metricSql;

    //指标对应的 hologres 表
    private final String tableName;

    //指标特定的查询条件
    private final String condition;

    //指标解释说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaMetricEnum(String resultFieldName, String metricSql, String tableName, String condition, String desc) {
        this.resultFieldName = resultFieldName;
        this.metricSql = metricSql;
        this.tableName = tableName;
        this.condition = condition;
        this.desc = desc;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getTableName() {
        return tableName;
    }

    public String getCondition() {
        return condition;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaMetricEnum[] values = TuiaMetricEnum.values();
        for (TuiaMetricEnum value : values) {
            enumList.add(value.toString());
        }
    }

}
