package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author zhx 2022-07-26
 * 程序化采量平台
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaProgramProductPlatformEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    EXT_GROUP("ext_group", "公司业务分类，大类"),

    EXT_TYPE("ext_type", "日志分类，小类"),

    PROGRAM_PRODUCT_ID("program_product_id", "程序化产品id"),

    PROGRAM_TASK_ID("program_task_id", "程序化任务id"),

    PROGRAM_ACCOUNT_ID("program_plan_id", "程序化计划id"),

    MEDIA_PLATFORM_ID("media_platform_id", "媒体平台id"),

    MEDIA_ACCOUNT_ID("media_account_id", "媒体账号id"),

    REPORT_TYPE("report_type", "数据上报类型 1:广告主上报给推啊 2:推啊上报给媒体"),

    PROGRAM_ADVERTISER_ID("program_advertiser_id", "程序化广告主id");


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaProgramProductPlatformEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
