package cn.com.duiba.bigdata.common.biz.service;

import cn.com.duiba.bigdata.common.biz.dto.KeyValueDto;
import cn.com.duiba.bigdata.common.biz.dto.SortDto;
import cn.com.duiba.bigdata.common.biz.enums.*;
import cn.com.duiba.bigdata.common.biz.form.HoloQueryForm;

import java.util.ArrayList;
import java.util.List;

public class Test {

    public static void main(String[] args) throws Exception {

        HoloQueryForm form = new HoloQueryForm();
        form.setStartTime("2023-11-09 10:00:00");
        form.setEndTime("2023-11-09 18:00:00");

        List<String> metricList = new ArrayList<>();
        metricList.add("LAUNCH_COUPON_PV");
        metricList.add("COUPON_EFFECT_CLICK_PV");
        form.setMetricList(metricList);

        List<String> calculateMetricList = new ArrayList<>();
        calculateMetricList.add("CTR");
        form.setCalculateMetricList(calculateMetricList);

        List<String> combineMetricList = new ArrayList<>();
        combineMetricList.add("TOTAL_PV");
        form.setCombineMetricList(combineMetricList);

        List<String> dimensionList = new ArrayList<>();
        dimensionList.add("APP_ID");
        dimensionList.add("ABTEST_PLAN_ID");
        dimensionList.add("ABTEST_GROUP_ID");
        form.setDimensionList(dimensionList);

        List<KeyValueDto> conditionList = new ArrayList<>();
        KeyValueDto dto1 = new KeyValueDto(TuiaDimensionEnum.ABTEST_PLAN_ID, 436);
        conditionList.add(dto1);
        KeyValueDto dto2 = new KeyValueDto(TuiaDimensionEnum.ABTEST_GROUP_ID, 1);
        conditionList.add(dto2);
//        KeyValueDto dto3 = new KeyValueDto(TuiaDimensionEnum.APP_ID, Arrays.asList("93845", "90800", "90115"));
//        conditionList.add(dto3);
        KeyValueDto dto4 = new KeyValueDto(TuiaCalculateMetricEnum.CTR, 0.5, OperatorsEnum.GE.toString());
        conditionList.add(dto4);
        KeyValueDto dto5 = new KeyValueDto(TuiaCombineMetricEnum.TOTAL_PV, 10000, OperatorsEnum.GE.toString());
        conditionList.add(dto5);
        form.setConditionList(conditionList);

        SortDto orderByMetric = new SortDto(TuiaCombineMetricEnum.TOTAL_PV.toString(), SortEnum.DESC.toString());
        form.setOrderByMetric(orderByMetric);

//        form.setDataShowType(HologresShowTypeEnum.HOUR.toString());

        form.setPageSize(5);
        form.setPageNumber(1);

        String sql = HoloSqlService.getQuerySql(form, 1);
        System.out.println(sql);

    }
}
