package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.enums.*;
import cn.com.duiba.bigdata.common.biz.interfaces.*;

import java.util.List;

/**
 * @author xugf 2023-11-28
 * 业务枚举工具类
 */
public class BusinessEnumUtil {

    /**
     * 获取维度枚举
     *
     * @param businessType 业务线类型
     * @param dimension    维度名称
     * @return DimensionEnum
     */
    public static DimensionEnum getDimensionEnum(int businessType, String dimension) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDimensionEnum.valueOf(dimension);
        }

        return null;
    }

    /**
     * 获取维度枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getDimensionEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDimensionEnum.enumList;
        }

        return null;
    }

    /**
     * 获取基础指标枚举
     *
     * @param businessType 业务线类型
     * @param metric       基础指标名称
     * @return MetricEnum
     */
    public static MetricEnum getMetricEnum(int businessType, String metric) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaMetricEnum.valueOf(metric);
        }

        return null;
    }

    /**
     * 获取基础指标枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getMetricEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaMetricEnum.enumList;
        }

        return null;
    }

    /**
     * 获取计算类指标枚举
     *
     * @param businessType 业务线类型
     * @param metric       计算类指标名称
     * @return CalculateMetricEnum
     */
    public static CalculateMetricEnum getCalculateMetricEnum(int businessType, String metric) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCalculateMetricEnum.valueOf(metric);
        }

        return null;
    }

    /**
     * 获取计算类指标枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getCalculateMetricEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCalculateMetricEnum.enumList;
        }

        return null;
    }

    /**
     * 获取组合类指标枚举
     *
     * @param businessType 业务线类型
     * @param metric       计算类指标名称
     * @return CombineMetricEnum
     */
    public static CombineMetricEnum getCombineMetricEnum(int businessType, String metric) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCombineMetricEnum.valueOf(metric);
        }

        return null;
    }

    /**
     * 获取组合类指标枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getCombineMetricEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCombineMetricEnum.enumList;
        }

        return null;
    }

    /**
     * 获取组合类指标枚举
     *
     * @param businessType 业务线类型
     * @param name 维度对应的属性名称
     * @return CombineMetricEnum
     */
    public static DictEnum getDictEnum(int businessType, String name) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDictEnum.valueOf(name);
        }

        return null;
    }

    /**
     * 获取维度属性枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getDictEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDictEnum.enumList;
        }

        return null;
    }


}
