/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class AliOssUtil {
    private OSS ossClient = null;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    protected OSS getOssClient() {
        if (this.ossClient != null) {
            return this.ossClient;
        }
        return this.initOssClient();
    }

    private synchronized OSS initOssClient() {
        if (this.ossClient != null) {
            return this.ossClient;
        }
        this.ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        return this.ossClient;
    }

    public void close() {
        this.ossClient.shutdown();
    }

    public void putObject(String bucketName, String objectName, InputStream input) {
        this.getOssClient().putObject(bucketName, objectName, input);
    }

    public InputStream getObjectContentInputStream(String bucketName, String objectName) {
        OSSObject ossObject = this.getOssClient().getObject(bucketName, objectName);
        return ossObject.getObjectContent();
    }

    public List<String> listObjects(String bucketName, String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        ObjectListing objectListing = this.getOssClient().listObjects(bucketName, prefix);
        for (OSSObjectSummary ossObject : objectListing.getObjectSummaries()) {
            list.add(ossObject.getKey());
        }
        return list;
    }

    public void renameObject(String bucketName, String sourceObjectName, String destinationObjectName) {
        this.getOssClient().copyObject(bucketName, sourceObjectName, bucketName, destinationObjectName);
        this.getOssClient().deleteObject(bucketName, sourceObjectName);
    }
}

