package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xugf 用户素材相关的统计数据（包含实时和离线）
 */
@Data
public class DeviceSlotMaterialDto implements Serializable {

    private static final long serialVersionUID = -8878033729399483497L;

    //用户当天的入口素材曝光列表(按照时间从早到晚排序)
    private List<Long> todayExposureList;

    //用户当天的入口素材点击列表(按照时间从早到晚排序)
    private List<Long> todayClickList;

    //用户最近7天的入口素材曝光列表(用 "," 分隔)
    private String weekExposureList;

    //用户最近7天的入口素材点击列表(用 "," 分隔)
    private String weekClickList;

    //用户最近28天曝光和点击过的素材列表相关统计数据
    private Map<Long, SlotMaterialDto> slotMaterialDtoMap = new HashMap<>();

    //二期特征
    //用户曝光点击素材的总次数（当天/7天/历史）
    private DimensionDataDto consumerTotalSlotMaterialData;

    //用户对各素材标签的曝光点击次数（当天/7天/历史）
    private Map<Long, DimensionDataDto> slotMaterialTagMap = new HashMap<>();

    //用户对各皮肤类型的曝光点击次数（当天/7天/历史）
    private Map<Long, DimensionDataDto> skinTypeMap = new HashMap<>();

    //用户对各奖品标签的曝光点击次数（当天/7天/历史）
    private Map<Long, DimensionDataDto> prizeTagMap = new HashMap<>();

    //用户+广告位对各素材标签的曝光点击次数（7天/历史）
    private Map<Long, DimensionDataDto> slotSlotMaterialTagMap = new HashMap<>();

    //用户+广告位对各皮肤类型的曝光点击次数（7天/历史）
    private Map<Long, DimensionDataDto> slotSkinTypeMap = new HashMap<>();

    //用户+广告位对各奖品标签的曝光点击次数（7天/历史）
    private Map<Long, DimensionDataDto> slotPrizeTagMap = new HashMap<>();


}
