package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;


@Data
public class DeviceSequenceDto implements Serializable {
    private static final long serialVersionUID = -316102112618444133L;
//{"bConvertAccounts":"21563","bConvertAdverts":"71121","bConvertResources":"07.09.0009","bConvertTrades":"15","clickAcIds":"35779,21563","clickAdIds":"70766,71121","clickReIds":"07.07.0005,07.09.0009","clickTrIds":"16,15","convAcIds":{"0":"21563","2":"21563","3":"21563","2_3_11":"21563"},"convAdIds":{"0":"71121","2":"71121","3":"71121","2_3_11":"71121"},"convReIds":{"0":"07.09.0009","2":"07.09.0009","3":"07.09.0009","2_3_11":"07.09.0009"},"convTrIds":{"0":"15","2":"15","3":"15","2_3_11":"15"},"convertAccounts":"21563","convertAdverts":"71121","convertResources":"07.09.0009","convertTrades":"15","dayOrderRank":3,"lastChargeNums":0,"orderRank":3}

    // 用户行为序
    private String clickAdIds; // 用户最近点击的广告id，逗号分隔, 和待打分的广告id交叉作为新特征f830001
    private String clickAcIds; // 用户最近点击的广告主id，逗号分隔, 和待打分的广告所属广告主id交叉作为新特征f830002
    private String clickReIds; // 用户最近点击的资源id，逗号分隔, 和待打分的广告所属资源id交叉作为新特征f830003
    private String clickTrIds; // 用户最近点击的广告二级行业id，逗号分隔, 和待打分的广告所属广告二级行业id交叉作为新特征f830004

    // 用户行为序 deviceId
    private String convertAdverts; // 831001	用户广告转化序列
    private String convertAccounts; // 831002	用户广告主转化序列
    private String convertResources; // 831003	用户资源转化序列
    private String convertTrades; // 831004	用户行业转化序列

    private String bConvertAdverts; // 832001	用户广告后端转化序列
    private String bConvertAccounts; // 832002	用户广告主后端转化序列
    private String bConvertResources; // 832003	用户资源后端转化序列
    private String bConvertTrades; // 832004	用户行业后端转化序列


    //用户订单序列
    private Long dayOrderRank; //f.实时 f601000-f601001
    private Long orderRank; // f602000-f602001
    private Long lastChargeNums; // f608000-f608001
}
