package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * hbase 实时特征表（所有设备号）
 *
 * @author xugf 2020-10-30
 */
@Data
public class DeviceFeatureOnlineDto implements Serializable {

    private static final long serialVersionUID = -7658170466011538340L;

    //活动访问-活动访问次数
    private Long activityRequest;

    //活动参与-活动参与次数
    private Long activityJoin;

    //全局广告位素材曝光次数
    private Long totalSlotMaterialExposure;

    //全局广告位素材点击次数
    private Long totalSlotMaterialClick;

    //全局Api广告位素材曝光次数
    private Long totalApiSlotMaterialExposure;

    //全局Api广告位素材点击次数
    private Long totalApiSlotMaterialClick;

    //用户当天的入口素材曝光列表(按照时间从早到晚排序)
    private List<Integer> slotMaterialExposureList;

    //用户当天的入口素材点击列表(按照时间从早到晚排序)
    private List<Integer> slotMaterialClickList;

    //用户当天的api入口素材曝光列表(按照时间从早到晚排序)
    private List<Integer> apiSlotMaterialExposureList;

    //用户当天的api入口素材点击列表(按照时间从早到晚排序)
    private List<Integer> apiSlotMaterialClickList;

    //综合行业（新行业）- 不同行业上发券数量
    private Map<Integer, Long> newAdvertIndustryLaunch = new HashMap<>();

    //综合行业（新行业）- 不同行业上计费点击数量
    private Map<Integer, Long> newAdvertIndustryEffectClick = new HashMap<>();

    //综合行业（新行业）- 不同行业上转化数量
    private Map<Integer, Long> newAdvertIndustryLPClick = new HashMap<>();


    //广告位素材- 不同广告位素材上的曝光
    private Map<Integer, Long> slotMaterialExposure = new HashMap<>();

    //广告位素材- 不同广告位素材上的点击
    private Map<Integer, Long> slotMaterialClick = new HashMap<>();

    //广告位素材标签- 不同广告位素材标签上的曝光
    private Map<Integer, Long> slotMaterialTagExposure = new HashMap<>();

    //广告位素材标签- 不同广告位素材标签上的点击
    private Map<Integer, Long> slotMaterialTagClick = new HashMap<>();


    //奖品标签- 不同奖品标签上的曝光
    private Map<Integer, Long> prizeTagExposure = new HashMap<>();

    //奖品标签- 不同奖品标签上的点击
    private Map<Integer, Long> prizeTagClick = new HashMap<>();

    //皮肤类型- 不同皮肤类型上的曝光
    private Map<Integer, Long> skinTypeExposure = new HashMap<>();

    //皮肤类型- 不同皮肤类型上的点击
    private Map<Integer, Long> skinTypeClick = new HashMap<>();


    //广告位素材- 不同api广告位素材上的曝光
    private Map<Integer, Long> apiSlotMaterialExposure = new HashMap<>();

    //广告位素材- 不同api广告位素材上的点击
    private Map<Integer, Long> apiSlotMaterialClick = new HashMap<>();

    //广告位素材标签- 不同api广告位素材标签上的曝光
    private Map<Integer, Long> apiSlotMaterialTagExposure = new HashMap<>();

    //广告位素材标签- 不同api广告位素材标签上的点击
    private Map<Integer, Long> apiSlotMaterialTagClick = new HashMap<>();


    //奖品标签- 不同api奖品标签上的曝光
    private Map<Integer, Long> apiPrizeTagExposure = new HashMap<>();

    //奖品标签- 不同api奖品标签上的点击
    private Map<Integer, Long> apiPrizeTagClick = new HashMap<>();

    //皮肤类型- 不同api皮肤类型上的曝光
    private Map<Integer, Long> apiSkinTypeExposure = new HashMap<>();

    //皮肤类型- 不同api皮肤类型上的点击
    private Map<Integer, Long> apiSkinTypeClick = new HashMap<>();

    //广告曝光
    private Long advertExposure;

    //广告点击次数
    private Long advertClick;


}
