package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author xugf 2020-10-30
 */
@Data
public class OneIdFeatureOfflineDto implements Serializable {

    private static final long serialVersionUID = 1510543069889149150L;


    //广告行业（一级行业/二级行业）- 不同行业上发券数量（历史所有）
    private Map<String, Long> advertMatchTagLaunchPv;

    //广告行业（一级行业/二级行业）- 不同行业上点击数量（历史所有）
    private Map<String, Long> advertMatchTagClickPv;

    //广告行业（一级行业/二级行业）- 不同行业上落地页转化数量（历史所有）
    private Map<String, Long> advertMatchTagEffectPv;


    //用户历史第几个订单序列/发券数
    private Long historyLaunch;

    //用户历史该活动第几个订单序列/发券数
    private Long historyActivityLaunch;

    //用户历史各广告发券数
    private Map<Integer, Long> historyAdvertLaunch;

    //用户历史各广告点击数
    private Map<Integer, Long> historyAdvertClick;

    //用户历史各广告转化数
    private Map<Integer, Long> historyAdvertEffect;

    //用户上次发券时间 yyyy-MM-dd HH:mm:ss
    private String lastLaunchTime;

    //用户该活动下上次发券时间 yyyy-MM-dd HH:mm:ss
    private String lastActivityLaunchTime;

    //用户该资源下上次发券时间 yyyy-MM-dd HH:mm:ss
    private Map<String, String> lastResourceLaunchTime;

    //用户上一次发券订单
    private String lastLaunchOrder;

    //用户上一次点击订单
    private String lastClickOrder;

    //用户该活动下上一次发券订单
    private String lastActivityLaunchOrder;

    //用户该活动下上一次点击订单
    private String lastActivityClickOrder;


    //用户各资源前一次发券订单
    private Map<String, String> lastResourceLaunchOrder;

    //用户各资源前一次点击订单
    private Map<String, String> lastResourceClickOrder;

    //用户各资源前一次转化订单
    private Map<String, String> lastResourceEffectOrder;


    //用户前一单活动
    private String lastActivity;

    //用户前一单广告二级行业标签
    private String lastAdvertMatchTag;

    //用户与前一单资源是否相同
    private String lastResource;

    //用户广告曝光序列
    private Set<Integer> advertExposureSet;

    //用户广告点击序列
    private Set<Integer> advertClickSet;

    //用户广告主点击序列
    private Set<Integer> accountClickSet;

    //用户资源点击序列
    private Set<String> resourceClickSet;

    //用户行业点击序列
    private Set<Integer> tradeClickSet;

    //用户广告转化序列
    private Set<Integer> advertEffectSet;

    //用户广告主转化序列
    private Set<Integer> accountEffectSet;

    //用户资源转化序列
    private Set<String> resourceEffectSet;

    //用户行业转化序列
    private Set<Integer> tradeEffectSet;

    ////设备号对应的ip关联的运营商
    private Integer ipIsp;

    //媒体-美团历史30天券访问次数
    private Long meiTuanAdvertRequestPv30Day ;

    // 媒体-美团历史30天券曝光次数
    private Long meiTuanAdvertExpousrePv30Day ;

    // 媒体-美团历史30天券有效点击次数
    private Long meiTuanAdvertEffectClickPv30Day ;

    //历史30天用户在不同资源位上发券数
    private Map<Integer, Long> historyResourceLaunch30Day ;

    //历史30天用户在不同资源上点击数
    private Map<Integer, Long> historyResourceClick30Day ;

    //历史30天用户在不同资源上最后转化数
    private Map<Integer, Long> historyResourceEffect30dDay ;

    //历史30天用户在不同广告主上发券数
    private Map<Integer, Long> historyAccountLaunch30Day ;

    //历史30天用户在不同广告主上点击数
    private Map<Integer, Long> historyAccountClick30Day ;

    //历史30天用户在不同广告主上转化数
    private Map<Integer, Long> historyAccountEffect30Day ;



}
