package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author xugf 2020-10-30
 */
@Data
public class OneIdFeatureOnlineDto implements Serializable {

    private static final long serialVersionUID = 1510543069889149150L;


    //用户当日第几个订单序列/发券数
    private Long todayLaunch;

    //用户当日该活动第几个订单序列/发券数
    private Long todayActivityLaunch;

    //用户当日各资源发券数
    private Map<String, Long> todayResourceLaunch;

    //用户当日各广告发券数
    private Map<Integer, Long> todayAdvertLaunch;

    //用户当日各广告点击数
    private Map<Integer, Long> todayAdvertClick;

    //用户当日各广告转化数
    private Map<Integer, Long> todayAdvertEffect;

    //用户当日各资源下点击广告个数
    private Map<String, Long> todayResourceClickAdvertCount;

    //用户当日各资源下转化广告个数
    private Map<String, Long> todayResourceEffectAdvertCount;

    //用户上一单广告主
    private String lastAccount;

    //用户上一单的广告id
    private String lastAdvert;


}
