package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.*;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.DMPForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.nezha.alg.feature.vo.ItemProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDMPService {

    /**
     * 获取设备号对应的标签和人群包
     * @param dmpForm 入参
     * @return 标签和人群包
     */
    DeviceTagDto getDeviceTag(DMPForm dmpForm);

    /**
     * 获取设备号对应的标签和人群包
     * @param dmpForm 入参
     * @param timeout 超时时间，单位毫秒
     * @return 标签和人群包
     */
    DeviceTagDto getDeviceTagWithTimeOut(DMPForm dmpForm, Long timeout);

    /**
     * 获取设备号对应的用户行为数据
     * @param dmpForm 入参
     * @return 行为数据
     */
    DeviceTagDto getDeviceActionData(DMPForm dmpForm);

    /**
     * 获取设备号对应的标签和人群包
     * @param dmpForm 入参
     * @return 标签和人群包
     */
    DeviceTagDto getDeviceNewPkg(DMPForm dmpForm);

    /**
     * 获取设备号对应的标签和人群包
     * @param dmpForm 入参
     * @param timeout 超时时间，单位毫秒
     * @return 标签和人群包
     */
    DeviceTagDto getDeviceNewPkgWithTimeOut(DMPForm dmpForm, Long timeout);

    /**
     * 获取设备号对应的人群包
     * @param dmpForm 入参
     * @return 人群包
     */
    DeviceTagDto getDevicePkg(DMPForm dmpForm);

    /**
     * 获取设备号对应的人群包
     * @param dmpForm 入参
     * @param timeout 超时时间，单位毫秒
     * @return 人群包
     */
    DeviceTagDto getDevicePkgWithTimeOut(DMPForm dmpForm, Long timeout);

    /**
     * 获取设备号对应的外部人群包
     * @param dmpForm 入参
     * @return 人群包
     */
    DeviceTagDto getDeviceExtTag(DMPForm dmpForm);

    /**
     * 获取设备号对应的外部人群包
     * @param dmpForm 入参
     * @param timeout 超时时间，单位毫秒
     * @return 人群包
     */
    public DeviceTagDto getDeviceExtTagWithTimeOut(DMPForm dmpForm, Long timeout);

    /**
     * 获取设备号的
     * @param dmpForm 入参
     * @return 设备特征
     */
    UserActFeature getDeviceFeature(DMPForm dmpForm);

    /**
     * 查询DPA活动推荐需要的设备号特征
     * @param dmpForm 入参
     * @return 设备特征
     */
    UserActFeature getDpaActDeviceFeature(DMPForm dmpForm);

    /**
     * 获取设备号对应的<item,score>
     * item advertId
     * @param dmpForm 入参
     *
     */
     Map<Long,Double> getAdvertScore(DMPForm dmpForm);


    /**
     * 获取imei标签
     * @param dmpForm 入参
     * @return imei标签
     */
    String getImeiTag(DMPForm dmpForm);

    /**
     * 获取imei标签
     * @param deviceId 设备号
     * @return 设备号对应的ip关联运营商
     */
    Integer getIpIsp(String deviceId);

    /**
     * 获取aiqiyi性别属性
     * @param deviceId 真实设备号
     * @return 爱奇艺性别
     */
    String getAqySex(String deviceId);
    /**
     * 获取aiqiyi属性
     * @param deviceId 真实设备号
     * @return 爱奇艺属性
     */
    AqyAttributeDto getAqyAttribute(String deviceId);

    /**
     * 获取商品特征
     * @return 商品画像
     */
    List<ItemProfileFeature> getItemFeature();

    /**
     * 获取广告位行为特征
     * @return行为画像
     */
    SlotActFeature getSlotBehaveFeature(String slotId);

    /**
     * 获取设备最近28天曝光和点击过的所有素材相关的统计数据
     * @param deviceId 设备id
     * @return 所有素材相关的统计数据
     */
    DeviceSlotMaterialDto getDeviceMaterialStatisticsData(String deviceId);

    /**
     * 获取设备相关行为数据
     * @param form 入参
     * @return 所有素材相关的统计数据
     */
    DeviceSlotMaterialDto getDeviceMaterialData(DMPForm form);

    /**
     * 获取用户基础属性，app安装列表，短信签名
     * @param imei 设备号
     * @return 基础数据
     */
    ImeiBasicAttributeDto getImeiBasicAttributeData(String imei);

    /**
     * 获取离线特征 素材推荐调用
     * @param deviceId 设备号
     * @return 离线特征
     */
    DeviceOfflineFeatureDto getDeviceOfflineFeature(String deviceId);

    /**
     * 获取用户序列 素材推荐调用
     * @param deviceId 设备号
     * @return 序列对象
     */
    DeviceSequenceDto getDeviceSequenceFeature(String deviceId);

    /**
     * 获取手淘人群包更新时间
     * @param deviceId 设备号（imei）
     * @return 人群包和时间
     */
    ShouTaoPkgDto getShouTaoPkg(String deviceId);

    /**
     * 美团算法新增特征提供接口
     * @param deviceId 设备号（imei）
     * @return MeiTuanFeatureDto
     */
    MeiTuanFeatureDto getMeiTuanFeature(String deviceId);

    /**
     * 获取设备号对应的算法测试人群包
     * @param deviceId
     * @param timeout
     * @return 人群包
     */
    List<String> getDeviceAlgRtaTag(String deviceId, Long timeout);
}
