package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author xugf 2020-10-30
 */
@Data
public class DeviceFeatureOfflineDto implements Serializable {

    private static final long serialVersionUID = 1510543069889149150L;


    //活动访问-活动访问次数（最近28天）
    private Long activityRequest28d;

    //活动访问-活动访问次数（最近7天）
    private Long activityRequest7d;

    //活动访问-距离上一次活动访问时间间隔，单位：天（最近28天）
    private Integer activityRequestInterval28d;

    //活动访问-活动访问频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer activityRequestPeriod28d;

    //活动参与-活动参与次数（最近28天）
    private Long activityJoin28d;

    //活动参与-活动参与次数（最近7天）
    private Long activityJoin7d;

    //广告曝光（最近7天）
    private Long advertExposoure7d;

    //广告曝光（最近28天）
    private Long advertExposoure28d;

    //广告点击次数（最近7天）
    private Long advertClick7d;

    //广告点击次数（最近28天）
    private Long advertClick28d;

    //活动参与-距离上一次活动参与时间间隔，单位：天（最近28天）
    private Integer activityJoinInterval28d;

    //活动参与-活动参与频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer activityJoinPeriod28d;

    //综合行业（新行业）- 不同行业上发券数量（最近28天）
    private Map<Integer, Long> newAdvertIndustryLaunch28d;

    //综合行业（新行业）- 不同行业上发券数量（最近7天）
    private Map<Integer, Long> newAdvertIndustryLaunch7d;

    //综合行业（新行业）- 上一次发券行业
    private Integer newAdvertIndustryLaunchLast;

    //综合行业（新行业）- 上一次发券是否点击
    private Integer newAdvertIndustryEffectClickSwitch;

    //综合行业（新行业）- 不同行业上计费点击数量（最近28天）
    private Map<Integer, Long> newAdvertIndustryEffectClick28d;

    //综合行业（新行业）- 不同行业上计费点击数量（最近7天）
    private Map<Integer, Long> newAdvertIndustryEffectClick7d;

    //综合行业（新行业）- 上一次计费点击行业
    private Integer newAdvertIndustryEffectClickLast;

    //综合行业（新行业）- 上一次计费点击是否转化
    private Integer newAdvertIndustryLPClickSwitch;

    //综合行业（新行业）- 不同行业上转化数量（最近28天）
    private Map<Integer, Long> newAdvertIndustryLPClick28d;

    //综合行业（新行业）- 不同行业上转化数量（最近7天）
    private Map<Integer, Long> newAdvertIndustryLPClick7d;

    //综合行业（新行业）- 上一次转化行业
    private Integer newAdvertIndustryLPClickLast;

    //活跃天数（最近14天）
    private Integer activeDay;

    //发券-距离上一次发券时间间隔，单位：天（最近28天）
    private Integer launchInterval28d;

    //发券-发券频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer launchPeriod28d;

    //计费点击-距离上一次计费点击时间间隔，单位：天（最近28天）
    private Integer effectClickInterval28d;

    //计费点击-计费点击频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer effectClickPeriod28d;

    //落地页转化-距离上一次转化时间间隔，单位：天（最近28天）
    private Integer LPClickInterval28d;

    //落地页转化-转化频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer LPClickPeriod28d;

    //SDK广告位素材-入口素材曝光总次数（最近28天）
    private Long sdkSlotMaterialExposureSum28d;

    //SDK广告位素材-入口素材曝光总次数（最近7天）
    private Long sdkSlotMaterialExposureSum7d;

    //SDK广告位素材-入口各素材曝光次数（最近28天）
    private Map<Long, Long> sdkSlotMaterialExposure28d;

    //SDK广告位素材-入口各素材曝光次数（最近7天）
    private Map<Long, Long> sdkSlotMaterialExposure7d;

    //SDK广告位素材-距离上一次各素材曝光时间间隔，单位：天（最近28天）
    private Map<Long, Integer> sdkSlotMaterialExposureInterval28d;

    //SDK广告位素材-入口各素材曝光频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Map<Long, Integer> sdkSlotMaterialExposurePeriod28d;

    //SDK广告位素材-曝光序列（最近7天, 按照时间从早到晚排序）
    private List<Long> sdkSlotMaterialExposureList7d;

    //SDK广告位素材-入口素材点击总次数（最近28天）
    private Long sdkSlotMaterialClickSum28d;

    //SDK广告位素材-入口素材点击总次数（最近7天）
    private Long sdkSlotMaterialClickSum7d;

    //SDK广告位素材-入口各素材点击次数（最近28天）
    private Map<Long, Long> sdkSlotMaterialClick28d;

    //SDK广告位素材-入口各素材点击次数（最近7天）
    private Map<Long, Long> sdkSlotMaterialClick7d;

    //SDK广告位素材-距离上一次各素材点击时间间隔，单位：天（最近28天）
    private Map<Long, Integer> sdkSlotMaterialClickInterval28d;

    //SDK广告位素材-入口各素材点击频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Map<Long, Integer> sdkSlotMaterialClickPeriod28d;

    //SDK广告位素材-点击序列（最近7天, 按照时间从早到晚排序）
    private List<Long> sdkSlotMaterialClickList7d;

    //SDK广告位素材标签-入口各素材标签曝光次数（最近28天）
    private Map<Long, Long> sdkSlotMaterialTagExposure28d;

    //SDK广告位素材标签-入口各素材标签曝光次数（最近7天）
    private Map<Long, Long> sdkSlotMaterialTagExposure7d;

    //SDK广告位素材标签-入口各素材标签点击次数（最近28天）
    private Map<Long, Long> sdkSlotMaterialTagClick28d;

    //SDK广告位素材标签-入口各素材标签点击次数（最近7天）
    private Map<Long, Long> sdkSlotMaterialTagClick7d;

    //SDK奖品标签-各奖品标签重复曝光次数（最近28天）
    private Map<Long, Long> sdkPrizesTagExposure28d;

    //SDK奖品标签-各奖品标签重复曝光次数（最近7天）
    private Map<Long, Long> sdkPrizesTagExposure7d;

    //SDK奖品标签-各奖品标签重复参与次数（最近28天）
    private Map<Long, Long> sdkPrizesTagJoin28d;

    //SDK奖品标签-各奖品标签重复参与次数（最近7天）
    private Map<Long, Long> sdkPrizesTagJoin7d;

    //SDK皮肤-各皮肤重复曝光次数（最近28天）
    private Map<Long, Long> sdkSkinsExposure28d;

    //SDK皮肤-各皮肤重复曝光次数（最近7天）
    private Map<Long, Long> sdkSkinsExposure7d;

    //SDK皮肤-各皮肤重复参与次数（最近28天）
    private Map<Long, Long> sdkSkinsJoin28d;

    //SDK皮肤-各皮肤重复参与次数（最近7天）
    private Map<Long, Long> sdkSkinsJoin7d;


    //API广告位素材-入口素材曝光总次数（最近28天）
    private Long apiSlotMaterialExposureSum28d;

    //API广告位素材-入口素材曝光总次数（最近7天）
    private Long apiSlotMaterialExposureSum7d;

    //API广告位素材-入口各素材曝光次数（最近28天）
    private Map<Long, Long> apiSlotMaterialExposure28d;

    //API广告位素材-入口各素材曝光次数（最近7天）
    private Map<Long, Long> apiSlotMaterialExposure7d;

    //API广告位素材-距离上一次各素材曝光时间间隔，单位：天（最近28天）
    private Map<Long, Integer> apiSlotMaterialExposureInterval28d;

    //API广告位素材-入口各素材曝光频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Map<Long, Integer> apiSlotMaterialExposurePeriod28d;

    //API广告位素材-曝光序列（最近7天, 按照时间从早到晚排序）
    private List<Long> apiSlotMaterialExposureList7d;

    //API广告位素材-入口素材点击总次数（最近28天）
    private Long apiSlotMaterialClickSum28d;

    //API广告位素材-入口素材点击总次数（最近7天）
    private Long apiSlotMaterialClickSum7d;

    //API广告位素材-入口各素材点击次数（最近28天）
    private Map<Long, Long> apiSlotMaterialClick28d;

    //API广告位素材-入口各素材点击次数（最近7天）
    private Map<Long, Long> apiSlotMaterialClick7d;

    //API广告位素材-距离上一次各素材点击时间间隔，单位：天（最近28天）
    private Map<Long, Integer> apiSlotMaterialClickInterval28d;

    //API广告位素材-入口各素材点击频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Map<Long, Integer> apiSlotMaterialClickPeriod28d;

    //API广告位素材-点击序列（最近7天, 按照时间从早到晚排序）
    private List<Long> apiSlotMaterialClickList7d;

    //API广告位素材标签-入口各素材标签曝光次数（最近28天）
    private Map<Long, Long> apiSlotMaterialTagExposure28d;

    //API广告位素材标签-入口各素材标签曝光次数（最近7天）
    private Map<Long, Long> apiSlotMaterialTagExposure7d;

    //API广告位素材标签-入口各素材标签点击次数（最近28天）
    private Map<Long, Long> apiSlotMaterialTagClick28d;

    //API广告位素材标签-入口各素材标签点击次数（最近7天）
    private Map<Long, Long> apiSlotMaterialTagClick7d;

    //API奖品标签-各奖品标签重复曝光次数（最近28天）
    private Map<Long, Long> apiPrizesTagExposure28d;

    //API奖品标签-各奖品标签重复曝光次数（最近7天）
    private Map<Long, Long> apiPrizesTagExposure7d;

    //API奖品标签-各奖品标签重复参与次数（最近28天）
    private Map<Long, Long> apiPrizesTagJoin28d;

    //API奖品标签-各奖品标签重复参与次数（最近7天）
    private Map<Long, Long> apiPrizesTagJoin7d;

    //API皮肤-各皮肤重复曝光次数（最近28天）
    private Map<Long, Long> apiSkinsExposure28d;

    //API皮肤-各皮肤重复曝光次数（最近7天）
    private Map<Long, Long> apiSkinsExposure7d;

    //API皮肤-各皮肤重复参与次数（最近28天）
    private Map<Long, Long> apiSkinsJoin28d;

    //API皮肤-各皮肤重复参与次数（最近7天）
    private Map<Long, Long> apiSkinsJoin7d;

    //adx频道（最近7天）
    private String adxChannel7d;

    //adx频道（最近14天）
    private String adxChannel14d;
}
