package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author jackxueman 2022-01-19
 */
@Data
public class DeviceFeatureOfflineNewDto implements Serializable {

    //adx
    //历史7天竞价次数
    private Long adxRequest7d;

    //历史7天曝光次数
    private Long adxExposure7d;

    //历史7天点击次数
    private Long adxClick7d;

    //历史7天素材曝光序列
    private String adxSlotMaterialExposureSeq7d;

    //历史7天素材点击序列
    private String adxSlotMaterialClickSeq7d;

    //adx-资源位
    //历史7天不同资源位竞价次数
    private Map<Long, Long> adxResourceRequest7d;

    //历史7天不同资源位曝光次数
    private Map<Long, Long> adxResourceExposure7d;

    //历史7天不同资源位点击次数
    private Map<Long, Long> adxResourceClick7d;

    // adx-推广组
    //历史7天不同 推广组竞价次数
    private Map<Long, Long> adxGroupRequest7d;

    //历史7天不同 推广组曝光次数
    private Map<Long, Long> adxGroupExposure7d;

    //历史7天不同 推广组点击次数
    private Map<Long, Long> adxGroupClick7d;

    //活动访问-活动访问次数（最近28天）
    private Long activityRequest28d;

    //活动访问-活动访问次数（最近14天）
    private Long activityRequest14d;

    //活动访问-活动访问次数（最近7天）
    private Long activityRequest7d;

    //活动访问-活动访问次数（最近1天）
    private Long activityRequest1d;

    //活动访问-距离上一次活动访问时间间隔，单位：天（最近28天）
    private Integer activityRequestInterval28d;

    //活动参与-活动参与次数（最近28天）
    private Long activityJoin28d;

    //活动参与-活动参与次数（最近7天）
    private Long activityJoin7d;

    //活动参与-距离上一次活动参与时间间隔，单位：天（最近28天）
    private Integer activityJoinInterval28d;

    //综合行业（新行业）
    //综合行业（新行业）- 不同行业上发券数量（最近28天）
    private Map<Integer, Long> newAdvertIndustryLaunch28d;

    //综合行业（新行业）- 不同行业上发券数量（最近7天）
    private Map<Integer, Long> newAdvertIndustryLaunch7d;

    //综合行业（新行业）- 上一次发券行业
    private Integer newAdvertIndustryLaunchLast;

    //综合行业（新行业）- 上一次发券是否点击
    private Integer newAdvertIndustryEffectClickSwitch;

    //综合行业（新行业）- 不同行业上计费点击数量（最近28天）
    private Map<Integer, Long> newAdvertIndustryEffectClick28d;

    //综合行业（新行业）- 不同行业上计费点击数量（最近7天）
    private Map<Integer, Long> newAdvertIndustryEffectClick7d;

    //综合行业（新行业）- 上一次计费点击行业
    private Integer newAdvertIndustryEffectClickLast;

    //综合行业（新行业）- 上一次计费点击是否转化
    private Integer newAdvertIndustryLPClickSwitch;


    //广告券
    //活跃天数（最近14天）
    private Integer activeDay14d;

    //发券-距离上一次发券时间间隔，单位：天（最近28天）
    private Integer launchInterval28d;

    //发券-发券频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer launchPeriod28d;

    //历史1天发券次数
    private Long advertLaunch1d;

    //历史7天发券次数
    private Long advertLaunch7d;

    //历史14天发券次数
    private Long advertLaunch14d;

    //券曝光
    //广告曝光（最近7天）
    private Long advertExposoure7d;

    //广告曝光（最近28天）
    private Long advertExposoure28d;

    //券点击
    //计费点击-距离上一次计费点击时间间隔，单位：天（最近28天）
    private Integer advertEffectClickInterval28d;

    //计费点击-计费点击频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer advertEffectClickPeriod28d;

    //广告点击次数（最近1天）
    private Long advertEffectClick1d;

    //广告点击次数（最近7天）
    private Long advertEffectClick7d;

    //广告点击次数（最近14天）
    private Long advertEffectClick14d;

    //广告点击次数（最近28天）
    private Long advertEffectClick28d;

    //用户历史序列特征（截断到20个，初始化近14天数据）
    //用户历史创意id曝光列表
    private Set<String> creativePlanExposureSet;

    //用户历史创意id点击列表
    private Set<String> creativePlanClickSet;

    //用户历史活动id访问列表
    private Set<String> activityRequestSet;

    //用户历史活动id参与列表
    private Set<String> activityJoinSet;

    //用户历史券id曝光列表
    private Set<String> advertExposureSet;

    //用户历史券id计费点击列表
    private Set<String> advertEffectClickSet;

    //用户历史券行业id曝光列表
    private Set<String> advertTradeExposureSet;

    //用户历史券行业id计费点击列表
    private Set<String> advertTradeEffectClickSet;

    //广告位素材
    //历史1天请求次数
    private Long slotMaterialRequest1d;

    //历史7天请求次数
    private Long slotMaterialRequest7d;

    //历史14天请求次数
    private Long slotMaterialRequest14d;

    //广告位素材-入口素材曝光次数（最近14天）
    private Long slotMaterialExposure14d;

    //广告位素材-入口素材曝光次数（最近7天）
    private Long slotMaterialExposure7d;

    //广告位素材-入口素材曝光次数（最近1天）
    private Long slotMaterialExposure1d;

    //广告位素材-入口素材点击次数（最近14天）
    private Long slotMaterialClick14d;

    //广告位素材-入口素材点击次数（最近7天）
    private Long slotMaterialClick7d;

    //广告位素材-入口素材曝光次数（最近1天）
    private Long slotMaterialClick1d;


}
