package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.CrowdDto;
import cn.com.duiba.bigdata.inner.service.api.form.DMPCrowdForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDMPInfoService {

    /**
     * 广告后台调用的人群包接口(人群包分页查询)
     * @param dmpForm crowdId，crowdName，validState，startTime，endTime，pageNum(必填)，pageSize(必填)，adminId(必填)
     * @return page 页码，size 当前页大小，total 总数，list:数据集合,详情见CrowdDto
     */
    Map<String, Object> advertCrowdList(DMPCrowdForm dmpForm);

    /**
     * 添加人群(文件上传)
     * @param form crowdName(人群包名称)，adminId(accountId)(广告主id)，
     *             dataType(数据类型：IMEIMD5 --> 1，IMEI--> 2 ,IDFA--> 3,IDFAMD5--> 4,IDFA 5,IDFA-MD5 6)，
     *             isAutoPush(是否自动推送)，deviceInfos(文件url列表)
     * @return 是否添加成功
     */
    Boolean advertAddCrowd(DMPCrowdForm form);

    /**
     * 文件追加
     * @param crowdId 人群包id
     * @param dataType dataType(数据类型：IMEIMD5 --> 1，IMEI--> 2 ,IDFA--> 3,IDFAMD5--> 4,IDFA 5,IDFA-MD5 6)
     * @param urls 文件url列表
     * @param isAutoPush isAutoPush(是否自动推送)
     * @return 是否追加成功
     */
    Boolean urlAppend(Long crowdId, Integer dataType, List<String> urls, Integer isAutoPush);

    /**
     * 检查人群包名称是否重复
     * @param crowdId 人群包id
     * @param adminId 广告主id
     * @param crowdName 人群包名称
     * @return 是否重复
     */
    Boolean duplicateName(Long crowdId, Long adminId, String crowdName);

    /**
     * 批量推送
     * @param crowdIds 人群包id列表
     * @return 是否推送成功
     */
    Boolean pushBatch(List<Long> crowdIds);

    /**
     * 编辑人群包
     * @param crowdId 人群包id
     * @param crowdName 人群包名称
     * @return 是否编辑成功
     */
    Boolean editCrowd(Long crowdId, String crowdName);

    /**
     * 人群包详情
     * @param crowdId 人群包id
     * @return 人群包详情
     */
    CrowdDto crowdDetail(Long crowdId);

}
