package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.FeatureCodeDto;
import cn.com.duiba.bigdata.inner.service.api.dto.TBAlgorithmFeatureDto;
import cn.com.duiba.bigdata.inner.service.api.dto.TBAlgorithmModelDto;
import cn.com.duiba.bigdata.inner.service.api.dto.TBFeatureCodeConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2021-04-25
 * 特征编码服务
 */
@AdvancedFeignClient
public interface RemoteFeatureCodeService {

    /**
     * 插入单个特征值
     *
     * @param dto 单个特征
     * @return true:成功 false:失败
     */
    boolean insert(FeatureCodeDto dto);

    /**
     * 批量插入特征值
     *
     * @param dtoList 特征集合
     * @return true:成功 false:失败
     */
    boolean batchInsert(List<FeatureCodeDto> dtoList);

    /**
     * 根据模型id，获取模型的配置元数据
     * @param modelId 模型id
     * @return 模型元数据
     */
    TBAlgorithmModelDto getModelMetadata(String modelId);

    /**
     * 根据特征id列表，获取特征的配置元数据
     * @param featureIds 特征id列表
     * @return 特征元数据集合
     */
    List<TBAlgorithmFeatureDto> getFeatureMetadata(List<String> featureIds);

    /**
     * 根据模型id，获取模型使用的所有特征id
     *
     * @param modelId 模型id
     * @return 特征id列表
     */
    List<String> getFeatureIdList(String modelId);

    /**
     * 根据特征id列表，获取特征值和稠密编码
     *
     * @param featureIds 特征id列表
     * @return 特征编码集合
     */
    List<TBFeatureCodeConfigDto> getFeatureIdAndCode(List<String> featureIds);

}
