package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.common.biz.dto.*;
import cn.com.duiba.bigdata.inner.service.api.form.HologresQueryForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteHologresService {

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据（即将废弃，替换成queryOnline 或者 queryOffline）
     *
     * @param form 查询条件
     * @return DruidResultDto
     */
    @Deprecated
    List<DruidResultDto> query(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (实时数据接口)
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryOnline(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (abTest数据接口)
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryAbTest(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (离线数据接口)
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryOffline(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (离线数据接口)
     *  兑吧-积分商城年度-统计数据接口
     * @param form 查询条件
     * @return DuibaIntegralMallDto
     */
    List<DuibaIntegralMallDto> queryIntegralMallOffline(HologresQueryForm form) throws Exception;


    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (兑吧直播数据接口)
     * @param form 查询条件
     * @return DuibaLiveDto
     * @throws Exception 异常
     */
    List<DuibaLiveDto> queryDuibaLive(HologresQueryForm form) throws Exception;


    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (兑吧活动数据)
     * @param form 查询条件
     * @return DuibaActivityDto
     * @throws Exception 异常
     */
    List<DuibaActivityDto> queryDuibaActivity(HologresQueryForm form) throws Exception;

    /**
     * 查询兑吧直播结果数据，只返回记录数，不返回明细结果
     * @param form 查询条件
     * @return 记录数
     * @throws Exception 异常
     */
    Long queryDuibaLiveSize(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的sql，从hologres中查询数据
     *
     * @param sql 查询sql
     * @return jsonArrayStr
     */
    String queryHoloSql(String sql) throws Exception;

    /**
     * 根据传入的sql，从hologres中查询数据
     *
     * @param dataBase 数据库
     * @param sql 查询sql
     * @return jsonArrayStr
     * @throws Exception 异常
     */
    String queryDataByHoloSql(String dataBase, String sql) throws Exception;

    /**
     * 执行hologres的sql语句
     *
     * @param dataBase 数据库
     * @param sql 需要执行的sql语句
     * @return 影响的记录数
     * @throws Exception 异常
     */
    Integer executeByHoloSql(String dataBase, String sql) throws Exception;

    /**
     * analyze holo的表
     *
     * @param dataBase  数据库
     * @param tableName 表名
     * @throws Exception 异常
     */
    void analyzeHoloTable(String dataBase, String tableName) throws Exception;


    /**
     * 获取holo库中分区表的所有分区数
     *
     * @param dataBaseName 库名
     * @param tableName    表名
     * @return 分区列表
     */
    List<String> getDataBaseTablePartitionList(String dataBaseName, String tableName) throws Exception;

    /**
     * 创建表的分区
     *
     * @param dataBaseName   库名
     * @param tableName      表名
     * @param partitionValue 分区值
     */
    void createDataBaseTablePartition(String dataBaseName, String tableName, Long partitionValue) throws Exception;

    /**
     * 删除表的分区
     *
     * @param dataBaseName   库名
     * @param tableName      表名
     * @param partitionValue 分区值
     */
    void dropDataBaseTablePartition(String dataBaseName, String tableName, Long partitionValue) throws Exception;

}
