package cn.com.duiba.bigdata.online.service.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteDeviceAppListService {

    /**
     * 查询设备安装列表 实时+离线表
     *
     * @param deviceId 设备id
     * @return 安装列表
     */
    String getDeviceAppList(String deviceId);

    /**
     * 查询设备安装列表 实时表
     *
     * @param deviceId 设备id
     * @return 安装列表
     */
    String getOnlineDeviceAppList(String deviceId);

    /**
     * 查询设备安装列表 离线表
     *
     * @param deviceId 设备id
     * @return 安装列表
     */
    String getOfflineDeviceAppList(String deviceId);
}
