package cn.com.duiba.bigdata.online.service.api.dto;

import java.io.Serializable;
import java.util.List;

public class ExternalDmpInfoDto implements Serializable {
    private static final long serialVersionUID = 5425570671038350488L;

    /**
     * 人群包ID信息列表，对象字段为：人群包id，人群包key
     */
    private List<ExternalCrowdDto> crowdIdInfos;
    /**
     * 第三方dmp厂家id
     */
    private Long externalDmpId;
    /**
     * 第三方dmp厂家名称
     */
    private String dmpName;
    /**
     * '数据更新机制:1每次、2每日、3每周、4每月、5永不
     */
    private Integer dataUpdateFre;
    /**
     * 数据源对接方式：对接DMP时定义
     */
    private String dataSourceType;
    /**
     * '第三方测试开关 0:关闭，1:开启 默认关闭',
     */
    private Integer enableState;
    /**
     * 有效时间，单位秒，默认-1，表示不更新；每次 0',
     */
    private Long  expireTime;
    /**
     * '切流比例，取值范围：0-100，默认100，表示不对流量做限制',
     */
    private Integer  flowRate;

    /**
     * 第三方dmp厂家DMP-id -key
     */
    private String dmpKey;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getExternalDmpId() {
        return externalDmpId;
    }

    public void setExternalDmpId(Long externalDmpId) {
        this.externalDmpId = externalDmpId;
    }

    public String getDmpName() {
        return dmpName;
    }

    public void setDmpName(String dmpName) {
        this.dmpName = dmpName;
    }

    public Integer getDataUpdateFre() {
        return dataUpdateFre;
    }

    public void setDataUpdateFre(Integer dataUpdateFre) {
        this.dataUpdateFre = dataUpdateFre;
    }

    public String getDataSourceType() {
        return dataSourceType;
    }

    public void setDataSourceType(String dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }

    public Long getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getFlowRate() {
        return flowRate;
    }

    public void setFlowRate(Integer flowRate) {
        this.flowRate = flowRate;
    }

    public String getDmpKey() {
        return dmpKey;
    }

    public void setDmpKey(String dmpKey) {
        this.dmpKey = dmpKey;
    }

    public List<ExternalCrowdDto> getCrowdIdInfos() {
        return crowdIdInfos;
    }

    public void setCrowdIdInfos(List<ExternalCrowdDto> crowdIdInfos) {
        this.crowdIdInfos = crowdIdInfos;
    }
}
