package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 配置表查询接口
 *
 * @author xugf
 */
@AdvancedFeignClient
public interface RemoteConfigService {

    /**
     * 获取日志topic的异常时间段
     *
     * @return topic对应的异常时间段集合
     */
    Map<String, List<String>> getLogErrorPeriod();

    /**
     * 获取指定topic的异常时间段
     *
     * @param topics topic
     * @return 异常时间段
     */
    List<String> getLogErrorPeriodByTopics(List<String> topics);
}
