package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.CrowdDto;
import cn.com.duiba.bigdata.online.service.api.dto.DeviceTagDto;
import cn.com.duiba.bigdata.online.service.api.dto.ExternalDmpInfoDto;
import cn.com.duiba.bigdata.online.service.api.dto.RTAExternalDmpInfoDto;
import cn.com.duiba.bigdata.online.service.api.form.DMPForm;
import cn.com.duiba.bigdata.online.service.api.form.DMPInfoForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDMPService {

    /**
     * 获取设备号对应的标签和人群包
     * @param dmpForm 入参
     * @return 标签和人群包
     */
    DeviceTagDto getDeviceTag(DMPForm dmpForm);

    /**
     *获取人群包列表
     * @param dmpForm DMP1.0 必传adminId ；
     * "accountId":25871 //该字段有值就返回，这个广告主对应的人群包id，无值就不返回系统推荐的人群包
     * @return 返回adminId 创建的私有人群+所有第三方dmp人群包(商业兴趣人群包+行业人群包)+系统推荐算法）；每个对象包含 人群包id ，人群包中文名 ，人群包类型 这 3个字段信息
     * crowdType 表示人群包类型：商业兴趣人群包crowdType=1，行业人群包crowdType=2，系统推荐人群包crowdType=3，我的人群包crowdType=5，
     */
    List<CrowdDto> getDMPInfos(DMPInfoForm dmpForm);

    /**
     *获取人群包列表
     * @param dmpForm DMP1.0 必传adminId ；
     * @return 返回Dmp测试标签列表（包括内部所有人群，外部所有人群（商业兴趣人群包+行业人群包+关闭），不包括算法人群包）每个对象包含 人群包id ，人群包中文名 ，人群包类型 这 3个字段信息
     * crowdType 表示人群包类型：商业兴趣人群包crowdType=1，行业人群包crowdType=2，我的人群包crowdType=5，关闭的人群包crowdType=6
     */
    List<CrowdDto> getDMPTestList(DMPInfoForm dmpForm); //该接口不包括算法人群包

    /**
     * 根据传入的广告主和使用场景，生成人群包id（给算法使用，获取人群包id，一个广告主和使用场景，唯一对应一个人群包）
     * @param dmpForm
     * "accountId":25871, //广告主id   必传
     *  "crowdName": "人群包名称算法1",  必传
     *  "algScene":1      //使用场景  必传
     * @return
     */
    CrowdDto  addAlgorithmCrowd(DMPInfoForm dmpForm);

    /**
     * //根据传入的广告主和使用场景，查询人群包id
     * @param dmpForm
     * "accountId":25871, //广告主id ， 必传
     * "algScene":1      //使用场景， 必传
     * @return
     */
    CrowdDto  queryAlgorithmCrowd(DMPInfoForm dmpForm);

    /**
     * //返回所有可用的算法创建的人群包信息（包含广告主id，使用场景，人群包id）

     * @return
     */
    List<CrowdDto> queryAllAlgorithmCrowdList( );
    /**
     *获取指定人群包
     * @param dmpForm 传指定crowdId人群包id
     * @return 只返回指定人群包id对象： 人群包id ，人群包中文名 ，人群包类型 这 3个字段信息
     */
    CrowdDto getSingleDMPInfo(DMPInfoForm dmpForm);

    /**
     *获取人群包列表
     * @param dmpForm DMP1.1 crowdIds   人群包crowdIds 列表  ；
     * @return 返回crowdIds人群包列表；根据入参：人群包crowdIds   过滤只返回 未被删除 且 有效状态的 crowdIds人群包列表；每个对象包含 人群包id ，人群包中文名 ，人群包类型 这 3个字段信息
     * 如果crowdIds 入参内容为空，返回结果也为空
     */
    List<CrowdDto> getDMPInfoByCrowdIs(DMPInfoForm dmpForm);

    /**
     * //查询外部dmp厂家信息（条件：开启状态的，enable_state=1）
     * 输入：无
     * 输出：dmp厂家明细列表和相应的人群包id
     * @return 默认无数据返回空[]
     */
    List<ExternalDmpInfoDto> queryExternalDmpInfoList();

    /**
     * //查询外部dmp厂家信息对应的人群包id列表 （条件：开启状态的，enable_state=1，媒体定向打开 app_state=1 ）
     * 输入：无
     * 输出：dmp厂家key列表 和相应的人群包ids
     *  @return 默认无数据返回空[]
     */
    List<RTAExternalDmpInfoDto> queryRTAExternalDmpInfoList();

}
