package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Map;

/**
 * 同步旧素材统计数据，缩短新素材启动时间
 * @author xugf 2019-09-29
 */
@AdvancedFeignClient
public interface RemoteMaterialDataSyncService {

    /**
     * 同步素材数据
     * @param oldMaterialId 旧素材id
     * @param newMaterialId 新素材id
     * @return true: 同步成功或者旧素材没有统计数据 false: 同步失败
     */
    Boolean copyMaterialData(Long oldMaterialId, Long newMaterialId);

    /**
     * 批量同步素材数据
     * @param materialMap key: 旧素材id value: 新素材id
     * @return key: 新素材id  value: (true: 同步成功或者旧素材没有统计数据 false: 同步失败)
     */
    Map<Long, Boolean> copyMaterialDataBatch(Map<Long, Long> materialMap);
}
