package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.ExcellentMaterialDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 广告位素材推荐
 * @author xugf 2019-12-16
 */
@AdvancedFeignClient
public interface RemoteSlotMaterialRecommendService {

    /**
     * 广告位素材推荐 获取优质素材，数据一天更新一次
     * @param curDate 日期 格式: yyyy-MM-dd
     * @return 优质素材列表
     */
    List<ExcellentMaterialDto> getExcellentMaterialList(String curDate);

    /**
     * 获取推荐的素材id
     * @param type 算法版本类型
     * @param slotId 广告位id
     * @return 素材id
     */
    Long getMaterialId(String type, Long slotId);

    /**
     * 移除本次海选池中的素材id(失效的素材)
     * @param type 算法版本
     * @param slotId 广告位id
     * @param materialId 素材id
     * @return true 表示移除成功 false 表示移除失败
     */
    Boolean removeMatchMaterialId(String type, Long slotId, Long materialId);
}
