package cn.com.duiba.bigdata.online.service.api.dto;

import cn.com.duiba.bigdata.inner.service.api.dto.SlotFeatureDto;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 广告行业特征数据
 */
@Data
public class TradeDataDto implements Serializable {

    private static final long serialVersionUID = 5425570671038350451L;

    /**
     * 行业id对应cvr
     */
    private Map<Long, Double> tradeCvr;
    /**
     * 行业id对应ctr type=7
     */
    private Map<Long, Double> tradeCtr;

    /**
     * json格式 行业/落地页标签一周交叉cvr
     */
    private String weekCvrStr;

    /**
     * 落地页一周全局cvr type=6时有值
     */
    private Double weekCvr;

    /**
     * 广告位特征对象
     */
    private SlotFeatureDto slotDto;

}
