package cn.com.duiba.bigdata.online.service.api.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 广告行业特征数据
 */
@Data
public class TradeDataForm implements Serializable {

    private static final long serialVersionUID = 5425570671038350451L;

    /**
     * 数据类型 1:媒体,2:媒体一级行业,3:媒体二级行业,4:素材,5:活动,6:md5落地页url,7:行业一周cvr/ctr，8：广告位
     */
    private Integer type;

    /**
     * 媒体id
     */
    private Long appId;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 媒体一级行业
     */
    private Long appFirstTrade;

    /**
     * 媒体二级行业
     */
    private Long appSecondTrade;

    /**
     * 广告位素材id
     */
    private Long slotMaterialId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 落地页urlMd5
     */
    private String urlMd5;

    /**
     * 行业id列表
     */
    private List<Long> tradeIds;

}
