package cn.com.duiba.bigdata.online.service.api.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xugf 2019-10-12
 */
@Data
public class TuiaRiskForm implements Serializable {

    private static final long serialVersionUID = -6386228437375877L;

    //需要查询的维度类型 具体查看TuiaRiskDimTypeKeys类
    private String dimType;

    //用户id
    private String consumerId;

    //天粒度的时间 格式：yyyyMMdd
    private String dayTime;

    //广告位
    private String slotId;

    //rid
    private String rid;

    //uuid6
    private String uuid6;

    //ip列表（查询多个ip）
    private List<String> ipList;

    //ip3段列表（查询多个ip3）
    private List<String> ip3List;

    //ua列表（查询多个ua）
    private List<String> uaList;

    //订单id列表（查询多个订单）
    private List<String> orderList;

    //设备id列表（查询多个设备）
    private List<String> deviceList;
}
