package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.AlgFeatureDto;
import cn.com.duiba.bigdata.online.service.api.dto.TradeDataDto;
import cn.com.duiba.bigdata.online.service.api.form.AlgForm;
import cn.com.duiba.bigdata.online.service.api.form.TradeDataForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAlgFeatureService {

    DmpFeature getAlgFeature(AlgForm form);

    String getAdvertFeature(AlgForm form);

    /**
     * 交叉特征实时接口
     * @param form type/id/tradeIds必填
     * @return tradeCvr
     */
    TradeDataDto getOnlineTradeData(TradeDataForm form);

    /**
     * 离线特征接口
     * @param form type/id 必填
     * @return
     */
    TradeDataDto getOfflineTradeData(TradeDataForm form);
}
