package cn.com.duiba.bigdata.online.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class AdxInCommonDto implements Serializable {
    private static final long serialVersionUID = -7387540661715372016L;

    //用户+资源位 下的素材id 对应 曝光次数
    private Map<Long,Long> exResSckMap ;

    //用户+资源位 下的素材id 对应 点击 次数
    private Map<Long,Long> clResSckMap ;

    //曝光素材离线序列
    private String exSckOffSeq;

    //点击素材离线序列
    private String clSckOffSeq;

    //用户+资源位 上次曝光素材id
    private Long lastExSck ;

    //用户+资源位 上次点击素材id
    private Long lastClSck ;

    //当日用户+资源位 素材id曝光序列 top30
    private List<Long> exResSckDaySeq;
    //当日用户+资源位 素材Id点击序列 top30
    private List<Long> clResSckDaySeq;

    //当日用户 素材曝光序列 list
    private List<Long> exSckDaySeq;
    //当日用户 素材点击序列 list
    private List<Long> clSckDaySeq;
}
