package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.DeviceFilterDto;
import cn.com.duiba.bigdata.online.service.api.dto.ResourceDataDto;
import cn.com.duiba.bigdata.online.service.api.form.DeviceResourceForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDeviceResourceService {

    /**
     * 获取设备号对应维度数据
     *
     * @param form 入参
     * @return 各维度数据
     */
    DeviceFilterDto getDeviceData(DeviceResourceForm form);

    /**
     * 获取设备号对应资源标签数据
     *
     * @param form 入参
     * @return 资源标签数据
     */
    List<ResourceDataDto> getResourceData(DeviceResourceForm form);

}
