package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.DuibaRiskDto;
import cn.com.duiba.bigdata.online.service.api.dto.DuibaRiskMergeDto;
import cn.com.duiba.bigdata.online.service.api.dto.TuiaRiskMergeDto;
import cn.com.duiba.bigdata.online.service.api.form.DuibaRiskForm;
import cn.com.duiba.bigdata.online.service.api.form.TuiaRiskForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDuibaRiskService {
    /**
     * 查询指标数据（合并后的结束数据）
     *
     * @param formList 入参
     * @return TuiaRiskMergeDto
     */
    DuibaRiskMergeDto getMergeData(List<DuibaRiskForm> formList);

    /**
     * 查询用户相关基础指标
     *
     * @param consumerId   用户id
     * @param appId        媒体id
     * @param activityId   活动id
     * @param activityType 活动类型
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getConsumerByActivity(String consumerId, String appId, String activityId,
                                       String activityType, String dayTime);

    /**
     * 查询用户相关基础指标
     *
     * @param consumerId 用户id
     * @param appId      媒体id
     * @param dayTime    天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getConsumerByApp(String consumerId, String appId, String dayTime);

    /**
     * 查询支付宝相关基础指标
     *
     * @param alipayAccount 支付宝账号
     * @param appId         媒体id
     * @param activityId    活动id
     * @param activityType  活动类型
     * @param dayTime       天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getAlipayAccountByActivity(String alipayAccount, String appId, String activityId,
                                            String activityType, String dayTime);


    /**
     * 查询ua相关基础指标
     *
     * @param uaMd5        ua或者os对应的md5值，注意：ua或者os需要先转成小写后再取md5
     * @param appId        媒体id
     * @param activityId   活动id
     * @param activityType 活动类型
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getUAByActivity(String uaMd5, String appId, String activityId,
                                 String activityType, String dayTime);

    /**
     * 查询ua相关基础指标
     *
     * @param uaMd5   ua或者os对应的md5值，注意：ua或者os需要先转成小写后再取md5
     * @param appId   媒体id
     * @param dayTime 天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getUAByApp(String uaMd5, String appId, String dayTime);

    /**
     * 查询ip相关基础指标 （分钟粒度）
     *
     * @param ip             用户ip
     * @param appId          媒体id
     * @param activityId     活动id
     * @param activityType   活动类型
     * @param minuteTimeList 分钟粒度时间集合 格式：yyyyMMddHHmm
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getIpByActivityAndMinute(String ip, String appId, String activityId,
                                          String activityType, List<String> minuteTimeList);

    /**
     * 查询ip相关基础指标
     *
     * @param ip           用户ip
     * @param appId        媒体id
     * @param activityId   活动id
     * @param activityType 活动类型
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getIpByActivity(String ip, String appId, String activityId,
                                 String activityType, String dayTime);

    /**
     * 查询ip相关基础指标
     *
     * @param ip      用户ip
     * @param appId   媒体id
     * @param dayTime 天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getIpByApp(String ip, String appId, String dayTime);

    /**
     * 查询ip前3段地址相关基础指标
     *
     * @param ip3          ip地址前3段
     * @param appId        媒体id
     * @param activityId   活动id
     * @param activityType 活动类型
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getIp3ByActivity(String ip3, String appId, String activityId,
                                  String activityType, String dayTime);

    /**
     * 查询ip前3段地址相关基础指标
     *
     * @param ip3     ip地址前3段
     * @param appId   媒体id
     * @param dayTime 天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getIp3ByApp(String ip3, String appId, String dayTime);

    /**
     * 查询统计数据 （目前是用hbase存储，后续会改成redis存储，目前受限于blink的cu资源）
     *
     * @param appId        媒体id
     * @param activityId   活动id
     * @param activityType 活动类型
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getStatDataByAppAndActivity(String appId, String activityId,
                                             String activityType, String dayTime);

    /**
     * 查询统计数据 （目前是用hbase存储，后续会改成redis存储，目前受限于blink的cu资源）
     *
     * @param appId   媒体id
     * @param dayTime 天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getStatDataByApp(String appId, String dayTime);

//-----consumer

    // 用户id + 媒体id +商品id + 天粒度
    /**
     * 查询用户相关基础指标
     *
     * @param consumerId   用户id
     * @param appId        媒体id
     * @param itemId      商品id
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getConsumerAppByItem(String consumerId, String appId, String itemId, String dayTime);

    /**
     * 查询用户相关基础指标
     *
     * @param consumerId   包含被助力用户id
     * @param appId        媒体id
     * @param activityId   活动id
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getAssConsumerAppByActivity(String consumerId, String appId, String activityId, String dayTime);

    //用户id + 媒体Id + 天粒度 可以复用
 // ----ip

    /**
     * 查询ip相关基础指标
     *
     * @param ip           用户ip
     * @param appId        媒体id
     * @param itemId        商品id
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getIpAppByItem(String ip, String appId, String itemId, String dayTime);

    //ip + 媒体id + 天粒度  可以复用

    /**
     * 查询ip相关基础指标
     *
     * @param ip           用户ip
     * @param appId        媒体id
     * @param activityId       活动id
     * @param assUserId   被助力用户
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getIpAppActByAssUser(String ip, String appId, String activityId, String assUserId,String dayTime);

//----device
    /**
     * 查询deviceId相关基础指标
     *
     * @param deviceId     设备ip
     * @param appId        媒体id
     * @param activityId   活动id
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getDeviceAppByActivity(String deviceId, String appId, String activityId, String dayTime);

    /**
     * 查询deviceId相关基础指标
     *
     * @param deviceId     设备ip
     * @param appId        媒体id
     * @param itemId       商品id
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getDeviceAppByItem(String deviceId, String appId, String itemId, String dayTime);

    /**
     * 查询deviceId相关基础指标
     *
     * @param deviceId     设备ip
     * @param appId        媒体id
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getDeviceApp(String deviceId, String appId, String dayTime);


    /**
     * 查询deviceId相关基础指标
     *
     * @param deviceId     设备ip
     * @param appId        媒体id
     * @param activityId   活动id
     * @param assUserId    被助力用户id
     * @param dayTime      天粒度时间 格式：yyyyMMdd
     * @return DuibaRiskDto实例
     */
    DuibaRiskDto getDeviceAppActByConsumer(String deviceId, String appId, String activityId, String assUserId,String dayTime);

}
