package cn.com.duiba.bigdata.recommender.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
public class DPADto implements Serializable {
    private static final long serialVersionUID = 5425570671038350488L;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 标题ID
     */
    private Long titleId;
    /**
     * 副标题ID
     */
    private Long subTitleId;
    /**
     * 奖品组合
     */
    private List<PrizeDto> prizeGroup = new ArrayList<>();

    /**
     * 组件活动或常规活动区分,0-常规,1-组件
     */
    private Integer actPackageType;

    /**
     * modelType=0-模型v002有候选集，1-模型v002无候选集，2-模型p001有候选集，3-模型p001无候选集
     */
    private Integer modelType;


}
