package cn.com.duiba.bigdata.recommender.service.api.form;

import cn.com.duiba.bigdata.recommender.service.api.dto.DPADto;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xugf 2019-11-15
 */
@Data
public class DPAForm implements Serializable {

    private static final long serialVersionUID = 5425570671038350451L;

    /**
     * 设备号
     */
    private String deviceId;

    /**
     * 媒体id
     */
    private Long appId;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 投放类型 0-人工 1-算法
     */
    private int activityType;

    /**
     * 预发券列表
     */
    private List<Long> advertList;

    /**
     * 组件活动对象 人工打印日志用
     */
    private DPADto dto;

    /**
     * 其他参数 ua,priceSection,areaCode,rid
     */
    private Map<String, String> param = new HashMap<>();

}
