/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.token;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duibabiz.component.token.TokenJsProperties;
import cn.com.duibabiz.component.token.TokenService;
import cn.com.duibabiz.component.token.impl.TokenServiceImpl;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisAutoConfiguration;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"duiba.biztool.token.enable"}, havingValue="true")
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnClass(value={AdvancedCacheClient.class})
@ConditionalOnBean(name={"redisTemplate"})
@EnableConfigurationProperties(value={TokenJsProperties.class})
public class TokenConfiguration {
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private TokenJsProperties tokenJsProperties;

    @Bean(name={"tokenCheckService"})
    public TokenService tokenCheckService() {
        if (this.advancedCacheClient == null) {
            throw new IllegalArgumentException("advancedCacheClient\u6ce8\u5165\u5931\u8d25");
        }
        return new TokenServiceImpl(this.advancedCacheClient, this.tokenJsProperties.getMultiDummyTokenJs());
    }
}

