/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.actionevent.impl;

import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerService;
import cn.com.duibabiz.component.actionevent.ActionEventConfig;
import cn.com.duibabiz.component.actionevent.UserActionEventMQProducer;
import cn.com.duibabiz.component.actionevent.UserActionEventNotifyDto;
import cn.com.duibabiz.component.actionevent.UserActionEventService;
import cn.com.duibabiz.component.actionevent.UserEventTypeEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class UserActionEventServiceImpl
implements UserActionEventService,
ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserActionEventServiceImpl.class);
    @Autowired
    private ActionEventConfig actionEventConfig;
    @Autowired
    private UserActionEventMQProducer userActionEventMQProducer;
    private ApplicationContext applicationContext;
    private static RemoteConsumerService remoteConsumerService;

    @Override
    public Boolean sendMsg(ConsumerDto consumerDto, Integer eventType, String actId, String actType, Long inviter) {
        if (consumerDto == null || !this.actionEventConfig.isEventNotifyApp(consumerDto.getAppId())) {
            return Boolean.FALSE;
        }
        ConsumerDto inviterConsumer = null;
        if (inviter != null) {
            try {
                inviterConsumer = remoteConsumerService.find(inviter);
            }
            catch (Exception e) {
                LOGGER.warn("\u53d1\u9001\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u5931\u8d25\uff0c\u67e5\u8be2consumerDto\u51fa\u9519, {}:{}", new Object[]{inviter, consumerDto.getAppId(), e});
            }
        }
        HashMap<String, Object> bizParams = new HashMap<String, Object>();
        if (inviterConsumer != null) {
            bizParams.put("inviter", inviterConsumer.getPartnerUserId());
        }
        return this.sendPrizeMsg(consumerDto, eventType, actId, actType, null, bizParams);
    }

    @Override
    public Boolean sendMsg(ConsumerDto consumerDto, Integer eventType, String actId, String actType) {
        return this.sendPrizeMsg(consumerDto, eventType, actId, actType, null, null);
    }

    @Override
    public Boolean sendPrizeMsg(Long consumerId, Long appId, Integer eventType, String actId, String actType, String prizeName, Map<String, Object> bizParams) {
        if (appId == null) {
            return Boolean.FALSE;
        }
        if (!this.actionEventConfig.isEventNotifyApp(appId)) {
            return Boolean.FALSE;
        }
        if (consumerId == null) {
            LOGGER.info("\u53d1\u9001\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u5931\u8d25\uff0cconsumerId\u6216appId\u4e3a\u7a7a, {}:{}", (Object)consumerId, (Object)appId);
            return Boolean.FALSE;
        }
        ConsumerDto consumerDto = null;
        try {
            consumerDto = remoteConsumerService.find(consumerId);
        }
        catch (Exception e) {
            LOGGER.warn("\u53d1\u9001\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u5931\u8d25\uff0c\u67e5\u8be2consumerDto\u51fa\u9519, {}:{}", new Object[]{consumerId, appId, e});
        }
        return this.sendPrizeMsg(consumerDto, eventType, actId, actType, prizeName, bizParams);
    }

    @Override
    public Boolean sendPrizeMsg(ConsumerDto consumerDto, Integer eventType, String actId, String actType, String prizeName, Map<String, Object> bizParams) {
        if (consumerDto == null || consumerDto.getId() == null) {
            return Boolean.FALSE;
        }
        if (!this.actionEventConfig.isEventNotifyApp(consumerDto.getAppId())) {
            return Boolean.FALSE;
        }
        UserActionEventNotifyDto userActionEventNotifyDto = this.wrapUserActionEventNotifyDto(consumerDto, eventType, actId, actType, prizeName, bizParams);
        if (Objects.equals(eventType, UserEventTypeEnum.WINPRIZE.getCode()) && BooleanUtils.isTrue((Boolean)this.actionEventConfig.getLogPrizeEvent())) {
            LOGGER.info("send award event: {}", (Object)JSONObject.toJSONString((Object)userActionEventNotifyDto));
        } else if (BooleanUtils.isTrue((Boolean)this.actionEventConfig.getLogEvent())) {
            LOGGER.info("send action event: {}", (Object)JSONObject.toJSONString((Object)userActionEventNotifyDto));
        }
        this.userActionEventMQProducer.sendMsg(userActionEventNotifyDto, this.actionEventConfig.getEventNotifyTopic());
        return Boolean.TRUE;
    }

    private UserActionEventNotifyDto wrapUserActionEventNotifyDto(ConsumerDto consumerDto, Integer eventType, String actId, String actType, String prizeName, Map<String, Object> bizParams) {
        return this.wrapUserActionEventNotifyDto(consumerDto.getAppId(), consumerDto.getId(), consumerDto.getPartnerUserId(), eventType, actId, actType, prizeName, bizParams);
    }

    private UserActionEventNotifyDto wrapUserActionEventNotifyDto(Long appId, Long consumerId, String uid, Integer eventType, String actId, String actType, String prizeName, Map<String, Object> bizParams) {
        UserActionEventNotifyDto dto = new UserActionEventNotifyDto();
        dto.setActId(actId);
        dto.setActType(actType);
        dto.setAppId(appId);
        Date now = new Date();
        dto.setBizId(this.generateBizId(appId, consumerId, actId, eventType, now.getTime()));
        dto.setConsumerId(consumerId);
        if (MapUtils.isNotEmpty(bizParams)) {
            dto.setBizParams(JSONObject.toJSONString(bizParams));
        }
        dto.setEventDate(now);
        dto.setEventType(eventType);
        dto.setPartnerUserId(uid);
        dto.setPrizeName(prizeName);
        return dto;
    }

    private String generateBizId(Long appId, Long consumerId, String actId, Integer eventType, long currentTime) {
        StringBuilder builder = new StringBuilder();
        builder.append(appId).append("_").append(consumerId).append("_").append(actId).append("_").append(eventType).append("_").append(currentTime);
        return builder.toString();
    }

    public void afterPropertiesSet() throws Exception {
        RemoteConsumerService remoteConsumerService = (RemoteConsumerService)this.applicationContext.getBean(RemoteConsumerService.class);
        if (remoteConsumerService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteConsumerService(in consumer-center)");
        }
        UserActionEventServiceImpl.remoteConsumerService = remoteConsumerService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

