/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.daily;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

public class DailyKeyUtil {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.BASIC_ISO_DATE;

    public static String getTodayKey(String userKey) {
        return DailyKeyUtil.generateKey(userKey, LocalDate.now());
    }

    private static String generateKey(String userKey, LocalDate localDate) {
        return userKey + localDate.format(DATE_TIME_FORMATTER);
    }

    public static Set<String> getRecentlyKeys(String userKey, int recentlyDays) {
        LocalDate now = LocalDate.now();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (recentlyDays == 0) {
            set.add(DailyKeyUtil.generateKey(userKey, now));
            return set;
        }
        for (int i = 0; i <= recentlyDays; ++i) {
            set.add(DailyKeyUtil.generateKey(userKey, now.minusDays(i)));
        }
        return set;
    }

    public static Date getExpireAt(Integer recordKeepDays) {
        recordKeepDays = Math.max(recordKeepDays, 1);
        return new Date(LocalDate.now().plusDays(recordKeepDays - 1).atTime(23, 59, 59, 59).toInstant(ZoneOffset.of("+8")).toEpochMilli());
    }
}

