/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duibabiz.component.filters.bloom.basic.RedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.daily.DailyRedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.AccessRecordInterceptor;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathStrategyFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DefaultBeanConfig {
    @Bean
    public UrlSerialAccessFilter urlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        return new UrlSerialAccessFilter(dailyRedisBloomFilter);
    }

    @Bean
    public DailyRedisBloomFilter dailyRedisBloomFilter(RedisBloomFilter redisBloomFilter) {
        return new DailyRedisBloomFilter(2, redisBloomFilter);
    }

    @Bean
    @ConditionalOnBean(value={StringRedisTemplate.class})
    public RedisBloomFilter redisBloomFilter() {
        return new RedisBloomFilter(5000, 200000, 0.001);
    }

    @Bean
    public PathStrategyFactory pathStrategyFactory() {
        return new PathStrategyFactory();
    }

    @Bean
    @ConditionalOnBean(value={UrlSerialAccessFilter.class, PathStrategyFactory.class})
    public AccessRecordInterceptor accessRecordInterceptor() {
        return new AccessRecordInterceptor();
    }
}

