/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.daily.DailyRedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathHandler;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathStrategyFactory;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UrlSerialAccessFilter
implements ApplicationContextAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(UrlSerialAccessFilter.class);
    private final DailyRedisBloomFilter dailyRedisBloomFilter;
    private PathStrategyFactory pathStrategyFactory;

    public UrlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        this.dailyRedisBloomFilter = dailyRedisBloomFilter;
    }

    private static String generateValue(Long cid, String path) {
        return cid + "_" + path;
    }

    public void record(Long cid, String path) {
        try {
            PathHandler handler = (PathHandler)this.pathStrategyFactory.getHandler(path);
            if (handler == null) {
                LOGGER.warn("urlSerialAccessService,record,handler is null,path={}", (Object)path);
                return;
            }
            String key = handler.generateKey4Record(this.getHttpServletRequest(), path);
            String value = UrlSerialAccessFilter.generateValue(cid, path);
            this.dailyRedisBloomFilter.put(key, value);
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,exception,cid={},path={}", new Object[]{cid, path, e});
        }
    }

    public Pair<Boolean, String> findFromRecords(Long cid, String path) {
        try {
            PathHandler handler = (PathHandler)this.pathStrategyFactory.getHandler(path);
            if (handler == null) {
                LOGGER.warn("urlSerialAccessService,findFromRecords,handler is null,path={}", (Object)path);
                return Pair.from((Object)true, null);
            }
            String key = handler.generateKey4Find(this.getHttpServletRequest(), path);
            String value = UrlSerialAccessFilter.generateValue(cid, path);
            return this.dailyRedisBloomFilter.mightContain(key, value);
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,findFromRecords,exception,cid={},path={}", new Object[]{cid, path, e});
            return Pair.from((Object)true, null);
        }
    }

    private HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.pathStrategyFactory = (PathStrategyFactory)applicationContext.getBean("pathStrategyFactory", PathStrategyFactory.class);
    }
}

