package cn.com.duibabiz.component.filters;

import com.google.common.collect.Lists;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * Created by xutao on 2019/4/16.
 */
@ConfigurationProperties(prefix = "duiba.domain.replace")
public class DuibaHostConfig {
	/**
	 * 需要被取代的domain列表
	 */
	private List<String> fromDomains = Lists.newArrayList(
			"activity-1.m.duiba.com.cn",
			"activity-2.m.duiba.com.cn",
			"activity-3.m.duiba.com.cn",
			"activity-4.m.duiba.com.cn",
			"activity-5.m.duiba.com.cn",
			"activity-6.m.duiba.com.cn",
			"activity-7.m.duiba.com.cn",
			"activity-8.m.duiba.com.cn",
			"activity-9.m.duiba.com.cn",
			"activity-10.m.duiba.com.cn");
	/**
	 * 需要被映射到的domain值
	 */
	private String toDomain = "activity.m.duiba.com.cn";

	public List<String> getFromDomains() {
		return fromDomains;
	}

	public String getToDomain() {
		return toDomain;
	}

	public void setFromDomains(List<String> fromDomains) {
		this.fromDomains = fromDomains;
	}

	public void setToDomain(String toDomain) {
		this.toDomain = toDomain;
	}
}
