package cn.com.duibabiz.component.filters.bloom.aop;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.url.AccessRecordInterceptor;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 基于注解实现拦截
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/15 20:19
 */
public class AdvanceAccessRecordInterceptor extends AccessRecordInterceptor {
    /**
     * 针对加了注解的方法进行拦截
     *
     * @param request
     * @param response
     * @param handler
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod hm = (HandlerMethod) handler;
            PathNeedAccess annotation = hm.getMethodAnnotation(PathNeedAccess.class);
            if (annotation != null) {
                String path = annotation.needAccessPath();

                Pair<Boolean, String> fromRecords = urlSerialAccessFilter.findFromRecords(RequestLocal.getCid(), path);
                if (!fromRecords.getKey()) {
                    throw new UrlAccessException(annotation.desc(), path);
                }
            }
        }
        return true;
    }
}
