package cn.com.duibabiz.component.filters.bloom.aop;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 接口顺序访问拦截
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/15 19:10
 */
@Target({ElementType.METHOD}) // 注解类型， 级别
@Retention(RetentionPolicy.RUNTIME) // 运行时注解
public @interface PathNeedAccess {
    /**
     * 需要访问的url
     */
    @AliasFor("value")
    String needAccessPath();

    @AliasFor("needAccessPath")
    String value();

    String desc() default "请重新进入活动";
}
