package cn.com.duibabiz.component.filters.bloom.daily;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 按日分组
 * biz_tool_K164_p30b33226+20201219
 *
 * @author zengsp
 */
public class DailyKeyUtil {

    /**
     * 格式：20111203
     */
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.BASIC_ISO_DATE;

    /**
     * 获取今天的
     */
    public static String getTodayKey(String userKey) {
        return generateKey(userKey, LocalDate.now());
    }

    private static String generateKey(String userKey, LocalDate localDate) {
        return userKey + localDate.format(DATE_TIME_FORMATTER);
    }

    /**
     * 为key加上日期后缀
     *
     * @param recentlyDays 0-今天，1-今天+昨天
     */
    public static Set<String> getRecentlyKeys(String userKey, int recentlyDays) {
        final LocalDate now = LocalDate.now();
        Set<String> set = new LinkedHashSet<>();
        if (recentlyDays == 0) {
            set.add(generateKey(userKey, now));
            return set;
        }
        for (int i = 0; i <= recentlyDays; i++) {
            set.add(generateKey(userKey, now.minusDays(i)));
        }
        return set;
    }


    /**
     * 获取过期时间，包括今天
     * 1-今天过期
     * 2-明天过期
     */
    public static Date getExpireAt(Integer recordKeepDays) {
        recordKeepDays = Math.max(recordKeepDays, 1);
        return new Date(LocalDate.now()
                .plusDays(recordKeepDays - 1)
                .atTime(23, 59, 59, 59)
                .toInstant(ZoneOffset.of("+8")).toEpochMilli());
    }
}
