package cn.com.duibabiz.component.filters.bloom.daily;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.basic.RedisBloomFilter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * 按天存储、查询的布隆过滤器
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/13 10:41
 */
public class DailyRedisBloomFilter {

    private final RedisBloomFilter redisBloomFilter;

    /**
     * 保存天数
     */
    private final Integer saveDays;

    public DailyRedisBloomFilter(Integer saveDays,
                                 RedisBloomFilter redisBloomFilter) {
        this.saveDays = saveDays;
        this.redisBloomFilter = redisBloomFilter;
    }


    /**
     * 保存到过滤器
     *
     * @param key   业务key
     * @param value 业务value
     */
    public void put(String key, String value) {
        String todayKey = DailyKeyUtil.getTodayKey(key);
        redisBloomFilter.put(todayKey, value, DailyKeyUtil.getExpireAt(saveDays));
    }


    /**
     * 判断是否存在于过滤器
     * 返回true的不一定存在，返回false的一定不存在
     *
     * @param key   业务key
     * @param value 业务value
     */
    public Pair<Boolean, String> mightContain(String key, String value) {
        Set<String> dayKeys = DailyKeyUtil.getRecentlyKeys(key, saveDays);

        for (String dayKey : dayKeys) {
            if (redisBloomFilter.mightContain(dayKey, value)) {
                // 只要有一天存在则存在
                return Pair.from(true, dayKey);
            }
        }
        return Pair.from(false, null);
    }

    /**
     * 获取信息
     *
     * @param key 业务key
     */
    public Map<String, Long> info(String key) {
        Set<String> dayKeys = DailyKeyUtil.getRecentlyKeys(key, saveDays);
        Map<String, Long> info = new LinkedHashMap<>();
        for (String dayKey : dayKeys) {
            info.putAll(redisBloomFilter.info(dayKey));
        }
        return info;
    }
}
