package cn.com.duibabiz.component.filters.bloom.url;


import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

/**
 * url访问记录器
 *
 * @author zengsp
 */
public class AccessRecordInterceptor implements HandlerInterceptor, ApplicationContextAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(AccessRecordInterceptor.class);

    protected UrlSerialAccessFilter urlSerialAccessFilter;
    protected PathStrategyFactory pathStrategyFactory;


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }


    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    /**
     * 针对访问进行记录
     */
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            Long cid = RequestLocal.getCid();
            if (Objects.isNull(cid) || cid <= 0L) {
                return;
            }
            String uri = request.getRequestURI();
            if (!pathStrategyFactory.getKeys().contains(uri)) {
                return;
            }
            urlSerialAccessFilter.record(cid, uri);
        } catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,exception", e);
        }
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.urlSerialAccessFilter = applicationContext.getBean("urlSerialAccessFilter", UrlSerialAccessFilter.class);
        this.pathStrategyFactory = applicationContext.getBean("pathStrategyFactory", PathStrategyFactory.class);
    }
}
