package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duibabiz.component.filters.bloom.basic.RedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.daily.DailyRedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathStrategyFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/15 20:58
 */
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE)
public class DefaultBeanConfig implements InitializingBean {
    @Bean
    public UrlSerialAccessFilter urlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        return new UrlSerialAccessFilter(dailyRedisBloomFilter);
    }

    @Bean
    public DailyRedisBloomFilter dailyRedisBloomFilter(RedisBloomFilter redisBloomFilter) {
        return new DailyRedisBloomFilter(2, redisBloomFilter);
    }

    @Bean
    @ConditionalOnBean(StringRedisTemplate.class)
    public RedisBloomFilter redisBloomFilter() {
        return new RedisBloomFilter(5000, 200_000, 0.001);
    }

    @Bean
    public PathStrategyFactory pathStrategyFactory() {
        return new PathStrategyFactory();
    }

    @Bean
    @ConditionalOnBean({UrlSerialAccessFilter.class, PathStrategyFactory.class})
    public AccessRecordInterceptor accessRecordInterceptor() {
        return new AccessRecordInterceptor();
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        System.out.println("aaaaa");
    }
}
