package cn.com.duibabiz.tools.strategy;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 处理器注册抽象类
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/14 20:24
 */
public abstract class AbstractStrategyFactory<K, V> implements ApplicationContextAware {
    private final Map<K, V> map = new HashMap<>();

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, V> map = applicationContext.getBeansOfType(getVClass());
        register(map);
    }

    /**
     * 注册处理器
     */
    private void register(Map<String, V> map) {
        for (V v : map.values()) {
            Set<K> ks = generateKey(v);
            for (K k : ks) {
                this.map.put(k, v);
            }
        }
    }

    public abstract Set<K> generateKey(V v);

    /**
     * 获取处理器
     */
    public V getHandler(K k) {
        return map.get(k);
    }

    public Set<K> getKeys() {
        return map.keySet();
    }

    /**
     * 获取泛型V的class
     */
    public Class<V> getVClass() {
        return (Class<V>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    }
}
