/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.daily;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.basic.RedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.daily.DailyKeyUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DailyRedisBloomFilter {
    private final RedisBloomFilter redisBloomFilter;
    private final Integer saveDays;

    public DailyRedisBloomFilter(Integer saveDays, RedisBloomFilter redisBloomFilter) {
        this.saveDays = saveDays;
        this.redisBloomFilter = redisBloomFilter;
    }

    public void put(String key, String value) {
        String todayKey = DailyKeyUtil.getTodayKey(key);
        this.redisBloomFilter.put(todayKey, value, DailyKeyUtil.getExpireAt(this.saveDays));
    }

    public Pair<Boolean, String> mightContain(String key, String value) {
        Set<String> dayKeys = DailyKeyUtil.getRecentlyKeys(key, this.saveDays);
        for (String dayKey : dayKeys) {
            if (!this.redisBloomFilter.mightContain(dayKey, value)) continue;
            return Pair.from((Object)true, (Object)dayKey);
        }
        return Pair.from((Object)false, null);
    }

    public Map<String, Long> info(String key) {
        Set<String> dayKeys = DailyKeyUtil.getRecentlyKeys(key, this.saveDays);
        LinkedHashMap<String, Long> info = new LinkedHashMap<String, Long>();
        for (String dayKey : dayKeys) {
            info.putAll(this.redisBloomFilter.info(dayKey));
        }
        return info;
    }
}

