/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duibabiz.component.filters.bloom.basic.RedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.daily.DailyRedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessInterceptor;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
public class DefaultBeanConfig
implements InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultBeanConfig.class);

    @Bean
    public UrlSerialAccessFilter urlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        return new UrlSerialAccessFilter(dailyRedisBloomFilter);
    }

    @Bean
    public DailyRedisBloomFilter dailyRedisBloomFilter(RedisBloomFilter redisBloomFilter) {
        return new DailyRedisBloomFilter(2, redisBloomFilter);
    }

    @Bean
    public RedisBloomFilter redisBloomFilter() {
        return new RedisBloomFilter(5000, 200000, 0.001);
    }

    @Bean
    public PathStrategyFactory pathStrategyFactory() {
        return new PathStrategyFactory();
    }

    @Bean
    public UrlSerialAccessInterceptor accessRecordInterceptor() {
        return new UrlSerialAccessInterceptor();
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.info("\u63a5\u53e3\u987a\u5e8f\u8bbf\u95ee\u4e00\u63fd\u5b50\u81ea\u52a8\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6bd5");
    }
}

