/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.daily.DailyRedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlSerialAccessFilter {
    public static final Logger LOGGER = LoggerFactory.getLogger(UrlSerialAccessFilter.class);
    private final DailyRedisBloomFilter dailyRedisBloomFilter;

    public UrlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        this.dailyRedisBloomFilter = dailyRedisBloomFilter;
    }

    public void record(PathHandler handler, Long cid) {
        if (handler == null || cid == null || cid <= 0L) {
            return;
        }
        String path = (String)handler.pathPair().getKey();
        try {
            String key = handler.generateKey4Record();
            String value = handler.generateValue(cid, path);
            this.dailyRedisBloomFilter.put(key, value);
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,exception,cid={},path={}", new Object[]{cid, path, e});
        }
    }

    public Pair<Boolean, String> intercept(PathHandler handler, Long cid) {
        Pair pair = Pair.from((Object)true, null);
        if (handler == null || cid == null || cid <= 0L) {
            return pair;
        }
        String path = (String)handler.pathPair().getKey();
        try {
            String key = handler.generateKey4Intercept();
            String value = handler.generateValue(cid, path);
            return this.dailyRedisBloomFilter.mightContain(key, value);
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,findFromRecords,exception,cid={},path={}", new Object[]{cid, path, e});
            return pair;
        }
    }
}

