/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessLocal;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathHandler;
import cn.com.duibabiz.component.filters.bloom.url.handler.PathStrategyFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UrlSerialAccessInterceptor
implements HandlerInterceptor,
ApplicationContextAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(UrlSerialAccessInterceptor.class);
    protected UrlSerialAccessFilter urlSerialAccessFilter;
    protected PathStrategyFactory pathStrategyFactory;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Long cid = RequestLocal.getCid();
        String uri = request.getRequestURI();
        try {
            PathHandler pathHandler = this.pathStrategyFactory.getHandlerByInterceptUrl(uri);
            if (pathHandler != null) {
                UrlSerialAccessLocal.set(this.urlSerialAccessFilter.intercept(pathHandler, cid));
            }
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,intercept,cid={},path={}", new Object[]{cid, uri, e});
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Long cid = RequestLocal.getCid();
        String uri = request.getRequestURI();
        try {
            PathHandler pathHandler = (PathHandler)this.pathStrategyFactory.getHandler(uri);
            if (pathHandler != null) {
                this.urlSerialAccessFilter.record(pathHandler, cid);
            }
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,exception,cid={},path={}", new Object[]{cid, uri, e});
        }
        UrlSerialAccessLocal.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.urlSerialAccessFilter = (UrlSerialAccessFilter)applicationContext.getBean(UrlSerialAccessFilter.class);
        this.pathStrategyFactory = (PathStrategyFactory)applicationContext.getBean(PathStrategyFactory.class);
        if (this.pathStrategyFactory == null) {
            throw new IllegalStateException("there must exists a bean of class PathStrategyFactory");
        }
        if (this.urlSerialAccessFilter == null) {
            throw new IllegalStateException("there must exists a bean of class UrlSerialAccessFilter");
        }
    }
}

